class Money
  attr_reader :value, :should_die
  def initialize(args, x, y)
    @value = 1

    @position = {x: x, y: y}
    @graphics = [
      {path: "sprites/money/Gem_Red.png", w: 32, h: 32, primitive_marker: :sprite},
      # {path: "sprites/money/Gem_Green.png", w: 32, h: 32, primitive_marker: :sprite},
      {path: "sprites/money/Gem_Blue.png", w: 32, h: 32, primitive_marker: :sprite}
    ]
    @frame_delay = 8
    @last_frame_time = 0
    @current_frame = 0
    @ttl = 5 * 60 #time to live, in frame count
    @should_die = false
    @is_fading = false
    @alpha = 255
  end

  def tick(args)

    if args.state.tick_count - @last_frame_time > @frame_delay
      @current_frame += 1
      @current_frame = @current_frame % (@graphics.count)
      @last_frame_time = args.state.tick_count
    end

    @alpha = ((@ttl < 60) && (@alpha == 255)) ? 128 : 255

    if @ttl <= 0
      @should_die = true
    end

    @ttl -= 1
  end

  def collision_rect
    {x: @position.x + 8, y: @position.y + 8, w: 16, h: 16}
  end

  def was_player_placed?
    false
  end

  def render
    # [
      {ttl: @ttl, a: @alpha}.merge(@position).merge(@graphics[@current_frame])
      # {primitive_marker: :border}.merge(Color::GREEN).merge(collision_rect),
      # {text: @ttl, size_px: 12, primitive_marker: :label}.merge(@position).merge(Color::BLACK)
    # ]
  end

  def inspect
    serialize.to_s
  end

  def serialize
    to_h
  end

  def to_s
    serialize.to_s
  end

  def to_h
    {**@position, should_die: @should_die, ttl: @ttl}
  end

  def mark_dead
    @ttl = 0
    @should_die = true
  end
end
